<?php
/**
 * Post Column Customize Custom Function
 * @package Panthar
 * @since 1.0.0
 */

if (!defined('ABSPATH')){
	exit(); //exit if access directly
}

if (!class_exists('panthar_Post_Column_Customize')){
	class panthar_Post_Column_Customize{
		//$instance variable
		private static $instance;
		
		public function __construct() {
			//service admin add table value hook
			add_filter("manage_edit-service_columns", array($this, "edit_service_columns") );
			add_action('manage_service_posts_custom_column', array($this, 'add_thumbnail_columns'), 10,2);
            //service category icon
            add_filter("manage_edit-service-cat_columns", array($this, "edit_service_cat_columns") );
            add_filter('manage_service-cat_custom_column', array($this, 'add_service_category_columns'), 13, 3);
            //packages admin add table value hook
            add_filter("manage_edit-packages_columns", array($this, "edit_packages_columns") );
            add_action('manage_packages_posts_custom_column', array($this, 'add_packages_thumbnail_columns'), 10,2);
            //packages category icon
            add_filter("manage_edit-packages-cat_columns", array($this, "edit_packages_cat_columns") );
            add_filter('manage_packages-cat_custom_column', array($this, 'add_packages_category_columns'), 13, 3);
            //case_study admin add table value hook
            add_filter("manage_edit-case_study_columns", array($this, "edit_case_study_columns") );
            add_action('manage_case_study_posts_custom_column', array($this, 'add_case_study_thumbnail_columns'), 20,4);
            //case_study category icon
            add_filter("manage_edit-case_study-cat_columns", array($this, "edit_case_study_cat_columns") );
            add_filter('manage_case_study-cat_custom_column', array($this, 'add_case_study_category_columns'), 23, 4);
            //team admin add table value hook
            add_filter("manage_edit-team_columns", array($this, "edit_team_columns") );
            add_action('manage_team_posts_custom_column', array($this, 'add_team_thumbnail_columns'), 20,4);
            //team category icon
            add_filter("manage_edit-team-cat_columns", array($this, "edit_team_cat_columns") );
            add_filter('manage_team-cat_custom_column', array($this, 'add_team_category_columns'), 23, 4);
		}

		/**
		 * get Instance
		 * @since 1.0.0
		 */
		public static function getInstance(){
			if (null == self::$instance){
				self::$instance = new self();
			}
			return self::$instance;
		}


		/**
		 * Edit service
		 * @since 1.0.0
		 */
		public function edit_service_columns($columns){

			$order = ( 'asc' == $_GET['order'] ) ? 'desc' : 'asc';
			$cat_title = $columns['taxonomy-service-cat'];
			unset($columns);
			$columns['cb'] = '<input type="checkbox" />';
			$columns['title'] = esc_html__('Title','panthar-core');
			$columns['thumbnail'] = '<a href="edit.php?post_type=service&orderby=title&order='.urlencode($order).'">'.esc_html__('Thumbnail','panthar-core').'</a>';
			$columns['taxonomy-service-cat'] = '<a href="edit.php?post_type=service&orderby=taxonomy&order='.urlencode($order).'">'.$cat_title.'<span class="sorting-indicator"></span></a>';
			$columns['date'] = esc_html__('Date','panthar-core');
			return $columns;
		}

		/**
		 * Add thumbnail
		 * @since 1.0.0
		 */
		public function add_thumbnail_columns($column,$post_id) {
			switch ( $column ) {
				case 'thumbnail' :
					echo '<a class="row-thumbnail" href="' . esc_url( admin_url( 'post.php?post=' . $post_id . '&amp;action=edit' ) ) . '">' . get_the_post_thumbnail( $post_id, 'thumbnail' ) . '</a>';
					break;
				default:
					break;
			}
		}

        /**
         * Service category column customize
         * @since 1.0.0
         */
        public function edit_service_cat_columns($columns){
            $columns['icon'] = esc_html__('Icon','panthar-core');
            return $columns;
        }

        /**
         * Service Category column add
         * @since 1.0.0
         */
        public function add_service_category_columns($string,$columns,$post_id){
            $post_term_meta = get_term_meta($post_id,'panthar_service_category',true);
            $icon = isset($post_term_meta['icon']) ? $post_term_meta['icon'] : '';
            switch ( $columns ) {
                case 'icon' :
                    echo '<i class="neaterller-font-size50 '.$icon.'"></i>';
                    break;
                default:
                    break;
            }
        }

        /**
         * Edit packages
         * @since 1.0.0
         */
        public function edit_packages_columns($columns){

            $order = ( 'asc' == $_GET['order'] ) ? 'desc' : 'asc';
            $cat_title = $columns['taxonomy-packages-cat'];
            unset($columns);
            $columns['cb'] = '<input type="checkbox" />';
            $columns['title'] = esc_html__('Title','panthar-core');
            $columns['thumbnail'] = '<a href="edit.php?post_type=packages&orderby=title&order='.urlencode($order).'">'.esc_html__('Thumbnail','panthar-core').'</a>';
            $columns['taxonomy-packages-cat'] = '<a href="edit.php?post_type=packages&orderby=taxonomy&order='.urlencode($order).'">'.$cat_title.'<span class="sorting-indicator"></span></a>';
            $columns['icon'] = esc_html__('Icon','panthar-core');
            $columns['date'] = esc_html__('Date','panthar-core');
            return $columns;
        }

        /**
         * Add packages thumbnail
         * @since 1.0.0
         */
        public function add_packages_thumbnail_columns($column,$post_id) {
            switch ( $column ) {
                case 'thumbnail' :
                    echo '<a class="row-thumbnail" href="' . esc_url( admin_url( 'post.php?post=' . $post_id . '&amp;action=edit' ) ) . '">' . get_the_post_thumbnail( $post_id, 'thumbnail' ) . '</a>';
                    break;
                case 'icon' :
                    $packages_meta_option = get_post_meta($post_id ,'panthar_packages_options', true);
                    $packages_icon = $packages_meta_option['packages_icon'];
                    printf('<i class="neaterller-font-size50 %s"></i>',esc_attr($packages_icon));
                    break;
                default:
                    break;
            }
        }

        /**
         * Packages category column customize
         * @since 1.0.0
         */
        public function edit_packages_cat_columns($columns){
            $columns['icon'] = esc_html__('Icon','panthar-core');
            return $columns;
        }

        /**
         * Packages Category column add
         * @since 1.0.0
         */
        public function add_packages_category_columns($string,$columns,$post_id){
            $post_term_meta = get_term_meta($post_id,'panthar_packages_category',true);
            $icon = isset($post_term_meta['icon']) ? $post_term_meta['icon'] : '';
            switch ( $columns ) {
                case 'icon' :
                    echo '<i class="neaterller-font-size50 '.$icon.'"></i>';
                    break;
                default:
                    break;
            }
        }

        /**
         * Edit case_study
         * @since 1.0.0
         */
        public function edit_case_study_columns($columns){

            $order = ( 'asc' == $_GET['order'] ) ? 'desc' : 'asc';
            $cat_title = $columns['taxonomy-case_study-cat'];
            unset($columns);
            $columns['cb'] = '<input type="checkbox" />';
            $columns['title'] = esc_html__('Title','panthar-core');
            $columns['thumbnail'] = '<a href="edit.php?post_type=case_study&orderby=title&order='.urlencode($order).'">'.esc_html__('Thumbnail','panthar-core').'</a>';
            $columns['taxonomy-case_study-cat'] = '<a href="edit.php?post_type=case_study&orderby=taxonomy&order='.urlencode($order).'">'.$cat_title.'<span class="sorting-indicator"></span></a>';
            $columns['icon'] = esc_html__('Icon','panthar-core');
            $columns['date'] = esc_html__('Date','panthar-core');
            return $columns;
        }

        /**
         * Add case_study thumbnail
         * @since 1.0.0
         */
        public function add_case_study_thumbnail_columns($column,$post_id) {
            switch ( $column ) {
                case 'thumbnail' :
                    echo '<a class="row-thumbnail" href="' . esc_url( admin_url( 'post.php?post=' . $post_id . '&amp;action=edit' ) ) . '">' . get_the_post_thumbnail( $post_id, 'thumbnail' ) . '</a>';
                    break;
                case 'icon' :
                    $case_study_meta_option = get_post_meta($post_id ,'panthar_case_study_options', true);
                    $case_study_icon = $case_study_meta_option['case_study_icon'];
                    printf('<i class="neaterller-font-size50 %s"></i>',esc_attr($case_study_icon));
                    break;
                default:
                    break;
            }
        }

        /**
         * Deals category column customize
         * @since 1.0.0
         */
        public function edit_case_study_cat_columns($columns){
            $columns['icon'] = esc_html__('Icon','panthar-core');
            return $columns;
        }

        /**
         * Deals Category column add
         * @since 1.0.0
         */
        public function add_case_study_category_columns($string,$columns,$post_id){
            $post_term_meta = get_term_meta($post_id,'panthar_case_study_category',true);
            $icon = isset($post_term_meta['icon']) ? $post_term_meta['icon'] : '';
            switch ( $columns ) {
                case 'icon' :
                    echo '<i class="neaterller-font-size50 '.$icon.'"></i>';
                    break;
                default:
                    break;
            }
        }

        /**
         * Edit team
         * @since 1.0.0
         */
        public function edit_team_columns($columns){

            $order = ( 'asc' == $_GET['order'] ) ? 'desc' : 'asc';
            $cat_title = $columns['taxonomy-team-cat'];
            unset($columns);
            $columns['cb'] = '<input type="checkbox" />';
            $columns['title'] = esc_html__('Title','panthar-core');
            $columns['thumbnail'] = '<a href="edit.php?post_type=team&orderby=title&order='.urlencode($order).'">'.esc_html__('Thumbnail','panthar-core').'</a>';
            $columns['taxonomy-team-cat'] = '<a href="edit.php?post_type=team&orderby=taxonomy&order='.urlencode($order).'">'.$cat_title.'<span class="sorting-indicator"></span></a>';
            $columns['date'] = esc_html__('Date','panthar-core');
            return $columns;
        }

        /**
         * Add team thumbnail
         * @since 1.0.0
         */
        public function add_team_thumbnail_columns($column,$post_id) {
            switch ( $column ) {
                case 'thumbnail' :
                    echo '<a class="row-thumbnail" href="' . esc_url( admin_url( 'post.php?post=' . $post_id . '&amp;action=edit' ) ) . '">' . get_the_post_thumbnail( $post_id, 'thumbnail' ) . '</a>';
                    break;
                case 'icon' :
                    $team_meta_option = get_post_meta($post_id ,'panthar_team_options', true);
                    break;
                default:
                    break;
            }
        }

        /**
         * Team category column customize
         * @since 1.0.0
         */
        public function edit_team_cat_columns($columns){
            $columns['icon'] = esc_html__('Icon','panthar-core');
            return $columns;
        }

        /**
         * Team Category column add
         * @since 1.0.0
         */
        public function add_team_category_columns($string,$columns,$post_id){
            $post_term_meta = get_term_meta($post_id,'panthar_team_category',true);
            $icon = isset($post_term_meta['icon']) ? $post_term_meta['icon'] : '';
            switch ( $columns ) {
                case 'icon' :
                    echo '<i class="neaterller-font-size50 '.$icon.'"></i>';
                    break;
                default:
                    break;
            }
        }

	}//end class
	if ( class_exists('panthar_Post_Column_Customize')){
		panthar_Post_Column_Customize::getInstance();
	}
}