<?php
/**
 * Elementor Widget
 * @package Panthar
 * @since 1.0.0
 */

namespace Elementor;
class Panthar_history_Slider_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'panthar-history-slider';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('History Slider', 'panthar-master');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['panthar_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'panthar-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'year', [
                'label' => esc_html__('Year', 'panthar-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('2005', 'panthar-core'),
                'description' => esc_html__('Enter Year', 'panthar-core')
            ]
        );
		$repeater->add_control(
            'banner_image', [
                'label' => esc_html__('Slide Banner Image', 'panthar-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload banner image', 'panthar-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );
        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'panthar-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Together we can make Better country', 'panthar-core'),
                'description' => esc_html__('Enter title', 'panthar-core')
            ]
        );
        $repeater->add_control(
            'description', [
                'label' => esc_html__('Slide Description', 'panthar-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('President represented Delaware for 36 years in the US', 'panthar-core'),
                'description' => esc_html__('enter description', 'panthar-core'),
            ]
        );
        $repeater->add_control(
            'stoke_title', [
                'label' => esc_html__('Stoke Title', 'panthar-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('PANTHAR', 'panthar-core'),
            ]
        );
        $repeater->add_control(
            'left_bg_image', [
                'label' => esc_html__('Left BG Image', 'panthar-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload Bg image', 'panthar-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );

        $this->add_control('testimonails_sliders', [
            'label' => esc_html__('Slider Items', 'panthar-master'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            
            'default' => [
                [
                    
                    'description' => esc_html__('President represented Delaware for 36 years in the US', 'panthar-master'),
                    'title' => esc_html__('Together we can make Better country', 'panthar-master'),
                ]
            ],

        ]);


        $this->end_controls_section();


        $this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Slider Settings', 'panthar-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__('Items', 'panthar-master'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('you can set how many item show in slider', 'panthar-master'),
                'default' => '1'
            ]
        );
	
		
		$this->add_control(
            'center',
            [
                'label' => esc_html__('Center', 'libo-master'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'libo-master'),

            ]
        );
		
        $this->add_control(
            'margin',
            [
                'label' => esc_html__('Margin', 'panthar-master'),
                'description' => esc_html__('you can set margin for slider', 'panthar-master'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 5,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]
        );

        $this->add_control(
            'loop',
            [
                'label' => esc_html__('Loop', 'panthar-master'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'panthar-master'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'progress_bar',
            [
                'label' => esc_html__('Slider Progress', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'panthar-core'),
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'nav',
            [
                'label' => esc_html__('Nav', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'panthar-core'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'nav_right_arrow',
            [
                'label' => esc_html__('Nav Right Icon', 'panthar-master'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'panthar-master'),
                'default' => [
                    'value' => 'fas fa-angle-right',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'nav_left_arrow',
            [
                'label' => esc_html__('Nav Left Icon', 'panthar-master'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'panthar-master'),
                'default' => [
                    'value' => 'fas fa-angle-left',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'panthar-master'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'panthar-master'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'autoplaytimeout',
            [
                'label' => esc_html__('Autoplay Timeout', 'panthar-master'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10000,
                        'step' => 2,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5000,
                ],
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]

        );

        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $all_header_items = $settings['testimonails_sliders'];
        $rand_numb = rand(333, 999999999);
		
		
		//slider settings
        $loop = $settings['loop'] ?? 'false';
        $center = $settings['center'] ? 'true' : 'false';
        $items = $settings['items'] ? $settings['items'] : 1;
        $autoplay = $settings['autoplay'] ? 'true' : 'false';
        $autoplaytimeout = $settings['autoplaytimeout']['size'] ?? '';
        $slider_settings = [
            "loop" => esc_attr($settings['loop']),
            "margin" => esc_attr($settings['margin']['size'] ?? 0),
            "items" => esc_attr($settings['items'] ?? 1),
            "center" => esc_attr($settings['center']),
            "autoplay" => esc_attr($settings['autoplay']),
            "autoplaytimeout" => esc_attr($settings['autoplaytimeout']['size'] ?? 0),
            "nav" => esc_attr($settings['nav']),
            "navleft" => panthar_core()->render_elementor_icons($settings['nav_left_arrow']),
            "navright" => panthar_core()->render_elementor_icons($settings['nav_right_arrow'])
        ] ?>
        
        <!-- Jour Journey Section Start Her -->
        <div class="history-wrap">
            <div class="container">
                <div class="history-slider">

                    <div class="history-slider-two history-number" id="history-navforr-carousel-<?php echo esc_attr($rand_numb); ?>" data-settings='<?php echo json_encode($slider_settings) ?>'>
                        <?php foreach ($all_header_items as $nav_itemm) : ?>
                        <div class="history-year">
                            <span class="animate-1"></span>
                            <span class="animate-2"></span>
                            <h3><?php echo esc_html($nav_itemm['year']) ?></h3>
                            <span class="animate-3"></span>
                            <span class="animate-4"></span>
                        </div>
                        <?php endforeach; ?>
                    </div>

                    <div class="history-slider-one" id="history-one-carousel-<?php echo esc_attr($rand_numb); ?>" data-settings='<?php echo json_encode($slider_settings) ?>'>
                        <?php
                        foreach ($all_header_items as $item): ?>
                            <div class="history-inner">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="history-details" style="background-image: url(<?php echo esc_url($item['left_bg_image']['url']) ?>);">
                                            <div class="content">
                                                <h4 class="title"><?php echo esc_html($item['title']) ?></h4>
                                                <p><?php echo esc_html($item['description']) ?></p>
                                                <div class="year-wrap d-flex">
                                                    <h2><?php echo esc_html($item['year']) ?></h2>
                                                    <i class="icomoon icomoon-bullet"></i>
                                                </div>
                                                <h2 class="stoke-title"><?php echo esc_html($item['stoke_title']) ?></h2>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="thumb">
                                            <div class="history-bg" style="background-image: url(<?php echo esc_url($item['banner_image']['url']) ?>);">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                    <?php if (!empty($settings['nav'] || $settings['progress_bar'])) : ?>
                        <div class="slick-carousel-controls mt-4">
                            <div class="row justify-content-center">
                                <?php if (!empty($settings['progress_bar'])) : ?>
                                    <div class="col-md-6 align-self-center">
                                        <div class="slider-controlprogress">
                                            <span class="slider__label sr-only"></span>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if (!empty($settings['nav'])) : ?>
                                    <div class="col-md-6">
                                        <div class="slider-nav"></div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
        <!-- Jour Journey Section End Her -->

        <?php
    }
}

Plugin::instance()->widgets_manager->register(new Panthar_history_Slider_Widget());