<?php
/**
 * Elementor Widget
 * @package Panthar
 * @since 1.0.0
 */

namespace Elementor;
class Panthar_Product_Grid_LIst_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'panthar-product-grid-list-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Product Grid List', 'panthar-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-gallery-grid';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['panthar_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control('blog_grid', [
            'label' => esc_html__('Blog Grid', 'panthar-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'col-lg-3' => esc_html__('col-lg-2', 'panthar-core'),
                'col-lg-3' => esc_html__('col-lg-3', 'panthar-core'),
                'col-lg-4' => esc_html__('col-lg-4', 'panthar-core'),
                'col-lg-6' => esc_html__('col-lg-6', 'panthar-core'),
            ),
            'default' => 'col-lg-4',
            'description' => esc_html__('Select Case Study Grid', 'panthar-core')
        ]);
        $this->add_control(
            'read_more',
            [
                'label' => esc_html__('Read More Show/Hide', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'panthar-core'),
                'default' => 'yes',
            ]
        );
        $this->add_control('read-btn', [
            'label' => esc_html__('Read More', 'panthar-core'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('enter read button text', 'panthar-core'),
            'default' => esc_html__('Read More', 'panthar-core'),
            'condition' => ['read_more' => 'yes'],
        ]);
        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'panthar-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many post you want in masonry , enter -1 for unlimited post.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'panthar-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => panthar_core()->get_terms_names('category', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'panthar-core'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'panthar-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'panthar-core'),
                'DESC' => esc_html__('Descending', 'panthar-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'panthar-core')
        ]);
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'panthar-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'panthar-core'),
                'title' => esc_html__('Title', 'panthar-core'),
                'date' => esc_html__('Date', 'panthar-core'),
                'rand' => esc_html__('Random', 'panthar-core'),
                'comment_count' => esc_html__('Most Comments', 'panthar-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'panthar-core')
        ]);
        $this->add_control('excerpt_length', [
            'label' => esc_html__('Excerpt Length', 'panthar-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                25 => esc_html__('Short', 'panthar-core'),
                55 => esc_html__('Regular', 'panthar-core'),
                100 => esc_html__('Long', 'panthar-core'),
            ),
            'default' => 25,
            'description' => esc_html__('select excerpt length', 'panthar-core')
        ]);
        $this->add_control(
            'thumb_date',
            [
                'label' => esc_html__('Thumb Date Show/Hide', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'panthar-core'),
            ]
        );
        $this->add_control(
            'details_date',
            [
                'label' => esc_html__('Details Date Show/Hide', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'panthar-core'),
            ]
        );
        $this->add_control(
            'bottom_border',
            [
                'label' => esc_html__('Bottom Border Show/Hide', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'panthar-core'),
            ]
        );
        $this->add_control(
            'pagination',
            [
                'label' => esc_html__('Pagination', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes to show pagination.', 'panthar-core'),
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'pagination_alignment',
            [
                'label' => esc_html__('Pagination Alignment', 'panthar-core'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'left' => esc_html__('Left Align', 'panthar-core'),
                    'center' => esc_html__('Center Align', 'panthar-core'),
                    'right' => esc_html__('Right Align', 'panthar-core'),
                ),
                'description' => esc_html__('you can set pagination alignment.', 'panthar-core'),
                'default' => 'left',
                'condition' => array('pagination' => 'yes')
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'title_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'title_style_tabs'
        );

        $this->start_controls_tab(
            'title_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'panthar-core'),
            ]
        );
        $this->add_control(
            'image_radius',
            [
                'label' => esc_html__('Image Radius', 'panthar-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .single-blog-item-inner .thumb' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control('normal_post_title_color', [
            'label' => esc_html__('Title Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-blog-item-inner .content .title" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('normal_post_title_hover_color', [
            'label' => esc_html__('Title Hover Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-blog-item-inner .details .title:hover" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('normal_post_paragraph_color', [
            'label' => esc_html__('Price Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-blog-item-inner .details .author-meta li" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('normal_background_color', [
            'label' => esc_html__('Background Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-blog-item-inner .content" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_control('normal_post_border_color', [
            'label' => esc_html__('Border Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-blog-item-inner .content" => "border-color: {{VALUE}}"
            ]
        ]);
        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'panthar-core'),
            ]
        );

        $this->add_control('hover_post_title_color', [
            'label' => esc_html__('Title Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-blog-item-inner .content .title:hover" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('normal_hover_background_color', [
            'label' => esc_html__('Background Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-blog-item-inner:hover .content" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_control('normal_post_hover_border_color', [
            'label' => esc_html__('Border Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-blog-item-inner:hover .content" => "border-color: {{VALUE}}"
            ]
        ]);
        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'typography_settings_section',
            [
                'label' => esc_html__('Typography Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'panthar-core'),
            'name' => 'post_meta_typography',
            'description' => esc_html__('select title typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .single-blog-item-inner .details .title"
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Price Typography', 'panthar-core'),
            'name' => 'category_typography',
            'description' => esc_html__('select category typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .single-blog-item-inner .details .author-meta li"
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $rand_numb = rand(333, 999999999);
        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];

        //other settings
        $pagination = $settings['pagination'] ? false : true;
        $pagination_alignment = $settings['pagination_alignment'];

        //setup query
        $args = array(
            'post_type' => 'product',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish',
            'ignore_sticky_posts' => 1,
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'category',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);
        ?>
        <div class="blog-list-item-wrap">
            <div class="row">
                <?php while ($post_data->have_posts()):$post_data->the_post(); 

                    //border condition here
                    $border_style_bottom = ' border-style-bottom';
                    if($settings['bottom_border'] == 'yes'){
                        $border_style_bottom = '';
                    }
                    //image condition here
                    $img_id = get_post_thumbnail_id(get_the_ID()) ? get_post_thumbnail_id(get_the_ID()) : false;
                    $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'panthar_grid_blog', false) : '';
                    $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                    $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);

                    $comments_count = get_comments_number(get_the_ID());
                    $comment_text = ($comments_count > 1) ? 'Comments (' . $comments_count . ')' : 'Comment (' . $comments_count . ')';
                    ?>
                    <?php global $product; ?>
                    
                    <div class="<?php echo esc_attr($settings['blog_grid']); ?> col-md-6">
                        <div class="single-blog-item-inner<?php echo esc_attr($border_style_bottom); ?>">
                            <div class="thumb">
                                <img src="<?php echo esc_url($img_url); ?>" alt="<?php echo esc_attr($img_alt); ?>">
                                <div class="cart-wrap">
                                    <?php $product = wc_get_product(get_the_ID()); ?>
                                    <a href="<?php echo $product->add_to_cart_url(); ?>">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24.746" height="22.148" viewBox="0 0 24.746 22.148">
                                          <g id="Group_25142asd" data-name="Group 25142" transform="translate(-6037 -8237)">
                                            <circle id="Ellipse_15asd" data-name="Ellipse 15" cx="1" cy="1" r="1" transform="translate(6046.276 8256.148)" fill="none" stroke="#7CB82F" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"/>
                                            <circle id="Ellipse_16asd" data-name="Ellipse 16" cx="1" cy="1" r="1" transform="translate(6055.276 8256.148)" fill="none" stroke="#7CB82F" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"/>
                                            <path id="Path_1145asd" data-name="Path 1145" d="M2,3H5.947l.764,3.383,1.9,8.393a2.253,2.253,0,0,0,2.2,1.756h9.683a2.255,2.255,0,0,0,2.2-1.766l1.863-8.383" transform="translate(6036 8235)" fill="none" stroke="#7CB82F" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"/>
                                            <path id="Path_1146asd" data-name="Path 1146" d="M23.979,6H6.5" transform="translate(6036.574 8235.383)" fill="none" stroke="#7CB82F" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"/>
                                          </g>
                                        </svg>
                                    </a>
                                    <a href="<?php echo get_the_permalink() ?>">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="13" viewBox="0 0 20 13">
                                        <g id="Group_25143lkj" data-name="Group 25143" transform="translate(-6057 -8306.5)">
                                            <rect id="Rectangle_30lkj" data-name="Rectangle 30" width="20" height="2" transform="translate(6057 8306.5)" fill="#7cb82f"/>
                                            <rect id="Rectangle_31lkj" data-name="Rectangle 31" width="20" height="2" transform="translate(6057 8312.5)" fill="#7cb82f"/>
                                            <rect id="Rectangle_32lkj" data-name="Rectangle 32" width="20" height="2" transform="translate(6057 8317.5)" fill="#7cb82f"/>
                                          </g>
                                        </svg>
                                    </a>
                                </div>
                            </div>
                            <div class="details">
                                <h5 class="title mt-0 mb-2"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                                <ul class="author-meta">
                                    <li class="author pl-0">
                                        <?php echo wp_kses($product->get_price_html(), 'panthar'); ?>
                                    </li>
                                </ul>
                                <?php if(!empty($settings['read_more'])) : ?>
                                    <div class="btn-wrap">
                                        <a href="<?php the_permalink(); ?>" class="read-btn"><?php echo esc_html($settings['read-btn']); ?> <span></span></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                        
                <?php
                endwhile;
                wp_reset_query();
                ?>
                <?php if (!$pagination) { ?>
                    <div class="col-lg-12">
                        <div class="blog-pagination text-<?php echo esc_attr($pagination_alignment) ?> margin-top-20">
                            
                                <?PHP Panthar()->post_pagination($post_data); ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register(new Panthar_Product_Grid_LIst_Widget());