<?php
/**
 * Elementor Widget
 * @package Panthar
 * @since 1.0.0
 */

namespace Elementor;
class Panthar_Section_Title_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'panthar-section-title-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Section Title', 'panthar-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-push';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['panthar_widgets'];
    }

    public function get_keywords()
    {
        return ['Section Title', 'Sponsor', 'section-title', "ThemeIM", 'Panthar'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'subtitle_plane_animation',
            [
                'label'   => esc_html__( 'Subtitle Plane Animation', 'panthar-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    'shape' => esc_html__( 'With Icon', 'panthar-core' ),
                    ''      => esc_html__( 'Without Icon', 'panthar-core' ),
                ],
            ]
        );
        $this->add_control(
            'plane_icon_left_control',
            [
                'label' => esc_html__('Icon Left Show/Hide', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'panthar-core'),
            ]
        );
        $this->add_control(
            'plane_icon_left',
            [
                'label' => esc_html__('Animation Icon Left', 'panthar-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('select Icon.', 'panthar-core'),
                'default' => [
                    'value' => 'icomoon bullet-left',
                    'library' => 'solid',
                ],
                'condition' => ['subtitle_plane_animation' => 'shape']
            ]
        );
        $this->add_control(
            'plane_icon_right',
            [
                'label' => esc_html__('Animation Icon Right', 'panthar-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('select Icon.', 'panthar-core'),
                'default' => [
                    'value' => 'icomoon bullet',
                    'library' => 'solid',
                ],
                'condition' => ['subtitle_plane_animation' => 'shape']
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Sub Title', 'panthar-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('About Panthar', 'bizbond-core'),
                'description' => esc_html__('enter title. use {c} color text {/c} for color text', 'panthar-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'panthar-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('What We Do', 'panthar-core'),
            ]
        );
        $this->add_control(
            'smalltitle',
            [
                'label' => esc_html__('Small Title', 'panthar-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('We believe in the following core values', 'bizbond-core'),
                'description' => esc_html__('enter title. use {c} color text {/c} for color text', 'panthar-core'),
            ]
        );
        $this->add_control(
            'description_status',
            [
                'label' => esc_html__('Description Show/Hide', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'panthar-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'panthar-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter  description.', 'panthar-core'),
                'default' => esc_html__('Top Packages', 'panthar-core'),
                'condition' => ['description_status' => 'yes']
            ]
        );
        $this->add_control(
            'btn_control',
            [
                'label' => esc_html__('Btn Control', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide Control', 'panthar-core'),
            ]
        );
        $this->add_control(
            'btn_style_white',
            [
                'label' => esc_html__('Btn Style White', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide Style White', 'panthar-core'),
                'condition' => ['btn_control' => 'yes']
            ]
        );
        $this->add_control(
            'readmore_text',
            [
                'label' => esc_html__('Readmore Text', 'panthar-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('CHECK ALL SERVICES', 'panthar-core'),
            ]
        );
        $this->add_control(
            'readmore_url',
            [
                'label' => esc_html__('Readmore Url', 'panthar-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('#', 'panthar-core'),
            ]
        );

        $this->add_responsive_control(
            'text_align',
            [
                'label' => esc_html__('Alignment', 'panthar-core'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'panthar-core'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'panthar-core'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'panthar-core'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'styling_section',
            [
                'label' => esc_html__('Styling Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'shape_top_space',
            [
                'label' => esc_html__('Shape Top Space', 'panthar-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}}.theme-heading-title' => 'padding-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'title_bottom_space',
            [
                'label' => esc_html__('Title Bottom Space', 'panthar-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .theme-heading-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control('subtitle_color', [
            'label' => esc_html__('Sub Title Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-heading-title .subtitle" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-heading-title .title" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('sub_title_color', [
            'label' => esc_html__('Sub Title Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-heading-title .subtitle" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('smalltitle_extra_color', [
            'label' => esc_html__('Smalltitle Extra Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-heading-title .smalltitle" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-heading-title p" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('title_extra_color', [
            'label' => esc_html__('Title Extra Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-heading-title .title span" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('read_more_color', [
            'label' => esc_html__('Read More Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-heading-title .btn-wrap .read-btn" => "color: {{VALUE}}",
                "{{WRAPPER}} .theme-heading-title .btn-wrap .read-btn span" => "background: {{VALUE}}",
                "{{WRAPPER}} .theme-heading-title .btn-wrap .btn-panthar" => "color: {{VALUE}}",
            ]
        ]);

        $this->end_controls_section();
        $this->start_controls_section(
            'styling_typogrpahy_section',
            [
                'label' => esc_html__('Typography Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'title_typography',
            'label' => esc_html__('Title Typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .theme-heading-title .title"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'sub_title_typography',
            'label' => esc_html__('Sub Title Typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .theme-heading-title .subtitle"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'title_extra_typography',
            'label' => esc_html__('Title Extra Typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .theme-heading-title .title span"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'description_typography',
            'label' => esc_html__('Description Typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .theme-heading-title p"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'read_more_typography',
            'label' => esc_html__('Read More Typography', 'panthar-core'),
            'selectors' => [
                "{{WRAPPER}} .theme-heading-title .btn-wrap .read-btn",
                "{{WRAPPER}} .theme-heading-title .btn-wrap .btn-panthar",
            ]
        ]);
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display(); 

        $btn_style_white = '';
        if(!empty($settings['btn_style_white'])){
            $btn_style_white = 'btn-style-white';
        }
        $animation = is_rtl()? 'fadeInRight':'fadeInLeft';
        $animation_left = is_rtl()? 'fadeInLeft':'fadeInRight';
        ?>

        <div class="theme-heading-title" style="text-align:<?php echo $settings['text_align']; ?>">
            <?php if(!empty($settings['subtitle'])) : ?>
                <div class="subtitle <?php echo $settings['subtitle_plane_animation'] ?>">
                    <div class="icon-left wow <?php echo $animation_left;?> animated <?php echo $settings['plane_icon_left_control']; ?>">
                        <?php
                        Icons_Manager::render_icon($settings['plane_icon_left'], ['aria-hidden' => 'true']);
                        ?>
                    </div>
                    <?php $subtitle = str_replace(['{c}', '{/c}'], ['<span>', '</span>'], $settings['subtitle']);
                    print wp_kses($subtitle, panthar_core()->kses_allowed_html('all'));
                    ?>
                    <div class="icon-right wow <?php echo $animation;?> animated">
                        <?php
                        Icons_Manager::render_icon($settings['plane_icon_right'], ['aria-hidden' => 'true']);
                        ?>
                    </div>
                </div>
            <?php endif ?>
            <?php if(!empty($settings['title'])) : ?>
                <h3 class="title">
                    <?php
                    $title = str_replace(['{c}', '{/c}'], ['<span>', '</span>'], $settings['title']);
                    print wp_kses($title, panthar_core()->kses_allowed_html('all'));
                    ?>
                </h3>
            <?php endif ?>
            <?php if(!empty($settings['smalltitle'])) : ?>
                <h6 class="smalltitle">
                    <?php
                    $smalltitle = str_replace(['{c}', '{/c}'], ['<span>', '</span>'], $settings['smalltitle']);
                    print wp_kses($smalltitle, panthar_core()->kses_allowed_html('all'));
                    ?>
                </h6>
            <?php endif ?>
            <?php
                if (!empty($settings['description_status'])) {
                    printf('<p>%1$s</p>', esc_html($settings['description']));
                }
            ?>
            <?php
                if (!empty($settings['readmore_text'])) { ?>
                    <?php if(!empty($settings['btn_control'])) { ?>
                        <div class="btn-wrap mt-2 pt-1">
                            <a href="<?php echo esc_html($settings['readmore_url']); ?>" class="btn-panthar btn-border-base <?php echo $btn_style_white; ?>"> 
                                <span class="top_left"></span>
                                <span class="top_right"></span>
                                <span>
                                    <?php echo esc_html($settings['readmore_text']); ?>
                                </span>
                                <span class="bottom_left"></span>
                                <span class="bottom_right"></span>
                            </a>
                        </div>
                    <?php }else { ?>
                        <div class="btn-wrap">
                            <a href="<?php echo esc_html($settings['readmore_url']); ?>" class="read-btn"><?php echo esc_html($settings['readmore_text']); ?> <span></span></a>
                        </div>
                    <?php } ?>
                <?php }
            ?>
        </div>
        <?php
    }
}
Plugin::instance()->widgets_manager->register(new Panthar_Section_Title_Widget());