<?php
/**
 * Elementor Widget
 * @package Panthar
 * @since 1.0.0
 */

namespace Elementor;
class Panthar_Testimonial_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'panthar-testimonial-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Testimonial', 'panthar-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-push';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['panthar_widgets'];
    }

    public function get_keywords()
    {
        return ['Core Value', 'Sponsor', 'Clint', "ThemeIM", 'Panthar'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
        //section heading
        $this->start_controls_section(
            'testimonial_section',
            [
                'label' => esc_html__('Testimonial Setting', 'panthar-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'slider_style', [
                'label' => esc_html__('Slider Style', 'panthar-core'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'style-1' => esc_html__('Style 01', 'panthar-core'),
                    'style-2' => esc_html__('Style 02', 'panthar-core'),
                    'style-3' => esc_html__('Style 03', 'panthar-core'),
                ),
                'default' => 'style-1',
            ]
        );
        $this->add_control(
            'rating_off',
            [
                'label' => esc_html__('Rating', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'panthar-core'),
            ]
        );
        $this->add_control(
            'mag_icon',
            [
                'label' => esc_html__('Message Icon', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'panthar-core'),
            ]
        );
        $this->end_controls_section();

        //section heading
        $this->start_controls_section(
            'section_heading',
            [
                'label' => esc_html__('heading Setting', 'panthar-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => ['slider_style' => 'style-1'],
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title', 'panthar-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('TESTIMONIAL', 'panthar-core'),
                'condition' => ['slider_style' => 'style-1'],
            ]
        );
        $this->add_control(
            'animate_icon',
            [
                'label' => esc_html__('Animation Icon', 'panthar-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('select Icon.', 'panthar-core'),
                'default' => [
                    'value' => 'icomoon bullet-left',
                    'library' => 'solid',
                ],
                'condition' => ['slider_style' => 'style-1'],
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'panthar-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('LOVES FROM SPECIAL CLIENTS', 'panthar-core'),
                'condition' => ['slider_style' => 'style-1'],
            ]
        );
        $this->add_control(
            'h_content',
            [
                'label' => esc_html__('Content', 'panthar-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eius tempor incididunt ut labore et dolore', 'panthar-core'),
                'condition' => ['slider_style' => 'style-1'],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Testimonial Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        //testimonial slider field
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'rating', [
                'label' => esc_html__('Rating', 'panthar-core'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    '1' => esc_html__('1 Star', 'panthar-core'),
                    '2' => esc_html__('2 Star', 'panthar-core'),
                    '3' => esc_html__('3 Star', 'panthar-core'),
                    '4' => esc_html__('4 Star', 'panthar-core'),
                    '5' => esc_html__('5 Star', 'panthar-core'),
                ),
                'default' => '5',
            ]
        );
        $repeater->add_control(
            'animate_icon',
            [
                'label' => esc_html__('Animation Icon', 'panthar-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('select Icon.', 'panthar-core'),
                'default' => [
                    'value' => 'fas fa-comment-alt',
                    'library' => 'solid',
                ],
            ]
        );
        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'panthar-core'),
                'type' => Controls_Manager::WYSIWYG,
                'default' => esc_html__('BEST EXPERT SHOOTER', 'panthar-core'),
            ]
        );
        $repeater->add_control(
            'content', [
                'label' => esc_html__('Content', 'panthar-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('A testimonial is effectively a review or recommendation from a client, letting other people know how your products or services benefitted them. Customer testimonials can take.', 'panthar-core'),
            ]
        );
        $repeater->add_control(
            'image', [
                'label' => esc_html__('Image', 'panthar-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'show_label' => false,
                'description' => esc_html__('upload image', 'panthar-core'),
            ]
        );
        $repeater->add_control(
            'name', [
                'label' => esc_html__('Name', 'panthar-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('Please add Your Name', 'panthar-core'),
                'default' => 'Morgaan Smith'
            ]
        );
        $repeater->add_control(
            'video_url', [
                'label' => esc_html__('Video Url', 'panthar-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('Please add Your Video Url', 'panthar-core'),
                'default' => '#'
            ]
        );
        $this->add_control('testimonial_items', [
            'label' => esc_html__('Testimonial Item', 'panthar-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],

        ]);
        $this->end_controls_section();

        $this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Slider Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'items',
            [
                'label' => esc_html__('Items', 'panthar-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('you can set how many item show in slider', 'panthar-core'),
                'default' => '2'
            ]
        );
        $this->add_control(
            'margin',
            [
                'label' => esc_html__('Margin', 'panthar-core'),
                'description' => esc_html__('you can set margin for slider', 'panthar-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 5,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]
        );
        $this->add_control(
            'loop',
            [
                'label' => esc_html__('Loop', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'panthar-core')
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'panthar-core'),

            ]
        );
        $this->add_control(
            'progress_bar',
            [
                'label' => esc_html__('Slider Progress', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'panthar-core'),
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'nav',
            [
                'label' => esc_html__('Nav', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'panthar-core'),
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'dots',
            [
                'label' => esc_html__('Dots', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'panthar-core'),
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'fade',
            [
                'label' => esc_html__('Fade', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'panthar-core'),
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'nav_left_arrow',
            [
                'label' => esc_html__('Nav Left Icon', 'panthar-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'panthar-core'),
                'default' => [
                    'value' => 'fas fa-arrow-left',
                    'library' => 'solid',
                ],
                'condition' => ['nav' => 'yes']
            ]
        );
        $this->add_control(
            'nav_right_arrow',
            [
                'label' => esc_html__('Nav Right Icon', 'panthar-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'panthar-core'),
                'default' => [
                    'value' => 'fas fa-arrow-right',
                    'library' => 'solid',
                ],
                'condition' => ['nav' => 'yes']
            ]
        );
        $this->add_control(
            'autoplaytimeout',
            [
                'label' => esc_html__('Autoplay Timeout', 'panthar-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10000,
                        'step' => 2,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5000,
                ],
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]

        );
        $this->end_controls_section();

        //STYLE FIELD HERE
        $this->start_controls_section(
            'core_value_style',
            [
                'label' => esc_html__('Styling Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('bg_color', [
            'label' => esc_html__('BG Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-core-value" => "background: {{VALUE}}"
            ]
        ]);
        $this->add_control('animate_border_color', [
            'label' => esc_html__('Animate Border Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-core-value .style-animate-dot-wrap:before " => "border-color: {{VALUE}}",
                "{{WRAPPER}} .single-core-value .style-animate-dot-wrap:after " => "border-color: {{VALUE}}",
            ]
        ]);
        $this->add_control('value_text_color', [
            'label' => esc_html__('Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-core-value p" => "color: {{VALUE}}",
                "{{WRAPPER}} .single-core-value p" => "color: {{VALUE}}",
            ]
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $rand_numb = rand(333, 999999999);

        //slider settings
        $slider_settings = [
            "loop" => esc_attr($settings['loop']),
            "margin" => esc_attr($settings['margin']['size'] ?? 0),
            "items" => esc_attr($settings['items'] ?? 1),
            "autoplay" => esc_attr($settings['autoplay']),
            "autoplaytimeout" => esc_attr($settings['autoplaytimeout']['size'] ?? 0),
            "fade" => esc_attr($settings['fade']),
            "nav" => esc_attr($settings['nav']),
            "dot" => esc_attr($settings['dots']),
            "navleft" => panthar_core()->render_elementor_icons($settings['nav_left_arrow']),
            "navright" => panthar_core()->render_elementor_icons($settings['nav_right_arrow'])
        ];
        //slick-carousel
        ?>
        <?php if($settings['slider_style'] == 'style-2') : ?>
            <div class="testimonial-wrap-2">
                <div class="testimonial-carousel-wrap">
                    <div class="testimonial-carousel" id="testimonial-one-carousel-<?php echo esc_attr($rand_numb); ?>" data-settings='<?php echo json_encode($slider_settings) ?>'>
                        <?php foreach ($settings['testimonial_items'] as $item): ?>
                            <div class="single-testimonial-inner-2">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="thumb" style="background: url('<?php echo $item['image']['url']; ?>');">
                                            <div class="rating">
                                                <?php  
                                                    $total_rat = $item['rating'];
                                                    for ($x = 1; $x <= $total_rat; $x++) { ?>
                                                       <i class="fa fa-star"></i>
                                                    <?php }
                                                ?>
                                            </div>
                                            <div class="message-icon">
                                                <?php Icons_Manager::render_icon($item['animate_icon'], ['aria-hidden' => 'true']); ?>
                                            </div>
                                            <div class="hover">
                                                <div class="hover-inner">
                                                    <a href="<?php echo esc_url($item['video_url']); ?>" class="video-play-btn-02 mfp-iframe"><i class="fa fa-play"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="details">
                                            <h6 class="title"><?php echo $item['title'] ?></h6>
                                            <p class="content"><?php echo $item['content'] ?></p>
                                            <h6 class="name mb-0"><?php echo $item['name'] ?></h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <?php if (!empty($settings['nav'] || $settings['progress_bar'])) : ?>
                        <div class="slick-carousel-controls slick-carousel-controls">
                            <div class="row">
                                <div class="col-lg-6 offset-lg-6">
                                    <div class="row justify-content-center">
                                        <?php if (!empty($settings['progress_bar'])) : ?>
                                            <div class="col-sm-7 align-self-center">
                                                <div class="slider-controlprogress">
                                                    <span class="slider__label sr-only"></span>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <?php if (!empty($settings['nav'])) : ?>
                                            <div class="col-sm-5 pr-lg-5 text-md-right">
                                                <div class="slider-nav"></div>
                                                <div class="slider-dots"></div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php elseif($settings['slider_style'] == 'style-3') : ?>
            <div class="testimonial-wrap-3">
                <div class="testimonial-carousel-wrap">
                    <div class="testimonial-carousel" id="testimonial-one-carousel-<?php echo esc_attr($rand_numb); ?>" data-settings='<?php echo json_encode($slider_settings) ?>'>
                        <?php foreach ($settings['testimonial_items'] as $item): ?>
                            <div class="single-testimonial-inner-3">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="thumb" style="background: url('<?php echo $item['image']['url']; ?>');">
                                            <?php if($settings['rating_off'] == 'yes') : ?>
                                                <div class="rating <?php echo esc_attr($settings['rating_off']); ?>">
                                                    <?php  
                                                        $total_rat = $item['rating'];
                                                        for ($x = 1; $x <= $total_rat; $x++) { ?>
                                                           <i class="fa fa-star"></i>
                                                        <?php }
                                                    ?>
                                                </div>
                                            <?php endif; ?>
                                            <?php if($settings['mag_icon'] == 'yes') : ?>
                                                <div class="message-icon">
                                                    <?php Icons_Manager::render_icon($item['animate_icon'], ['aria-hidden' => 'true']); ?>
                                                </div>
                                            <?php endif; ?>
                                            <?php if(!empty($item['video_url'])) : ?>
                                                <div class="hover">
                                                    <div class="hover-inner">
                                                        <a href="<?php echo esc_url($item['video_url']); ?>" class="video-play-btn-02 mfp-iframe"><i class="fa fa-play"></i></a>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="details">
                                            <span class="animate-img"></span>
                                            <h6 class="title"><?php echo esc_html($item['title']); ?></h6>
                                            <p class="content"><?php echo esc_html($item['content']); ?></p>
                                            <?php if(!empty($item['name'])) : ?>
                                                <h6 class="name mb-0"><?php echo esc_html($item['name']); ?></h6>
                                            <?php endif; ?>
                                            <span class="animate-img-2"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <?php if (!empty($settings['nav'] || $settings['progress_bar'])) : ?>
                        <div class="slick-carousel-controls slick-carousel-controls">
                            <div class="row">
                                <div class="col-md-6 offset-md-6">
                                    <div class="row justify-content-center">
                                        <?php if (!empty($settings['progress_bar'])) : ?>
                                            <div class="col-sm-5 align-self-center">
                                                <div class="slider-controlprogress">
                                                    <span class="slider__label sr-only"></span>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <?php if (!empty($settings['nav'])) : ?>
                                            <div class="col-sm-6 pr-lg-5 text-lg-right">
                                                <div class="slider-nav"></div>
                                                <div class="slider-dots"></div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php else : ?>
            <div class="testimonial-wrap">
                <div class="row">
                    <div class="col-lg-4 align-self-center">
                        <div class="theme-heading-title">
                            <?php if(!empty($settings['sub_title'])) : ?>
                                <div class="subtitle">
                                    <?php
                                    $subtitle = str_replace(['{c}', '{/c}'], ['<span>', '</span>'], $settings['sub_title']);
                                    print wp_kses($subtitle, panthar_core()->kses_allowed_html('all'));
                                    ?>
                                    <div class="icon-right wow fadeInLeft animated">
                                        <?php Icons_Manager::render_icon($settings['animate_icon'], ['aria-hidden' => 'true']); ?>
                                    </div>
                                </div>
                            <?php endif ?>
                            <?php if(!empty($settings['title'])) : ?>
                                <h3 class="title">
                                    <?php
                                    $title = str_replace(['{c}', '{/c}'], ['<span>', '</span>'], $settings['title']);
                                    print wp_kses($title, panthar_core()->kses_allowed_html('all'));
                                    ?>
                                </h3>
                            <?php endif ?>
                            <?php
                                if (!empty($settings['h_content'])) {
                                    printf('<p>%1$s</p>', esc_html($settings['h_content']));
                                }
                            ?>
                        </div>
                    </div>
                    <div class="col-lg-8">
                        <div class="testimonial-carousel-wrap">
                            <div class="testimonial-carousel" id="testimonial-one-carousel-<?php echo esc_attr($rand_numb); ?>" data-settings='<?php echo json_encode($slider_settings) ?>'>
                                <?php foreach ($settings['testimonial_items'] as $item): ?>
                                    <div class="single-testimonial-inner">
                                        <div class="rating">
                                            <?php  
                                                $total_rat = $item['rating'];
                                                for ($x = 1; $x <= $total_rat; $x++) { ?>
                                                   <i class="fa fa-star"></i>
                                                <?php }
                                            ?>
                                        </div>
                                        <div class="message-icon">
                                            <?php Icons_Manager::render_icon($item['animate_icon'], ['aria-hidden' => 'true']); ?>
                                        </div>
                                        <p class="content"><?php echo $item['content'] ?></p>
                                        <div class="media">
                                            <div class="media-left">
                                                <img src="<?php echo $item['image']['url']; ?>" alt="<?php echo esc_attr('img', 'panthar-core'); ?>">
                                            </div>
                                            <div class="media-body align-self-center">
                                                <h6 class="mb-0"><?php echo $item['name'] ?></h6>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <?php if (!empty($settings['nav'] || $settings['progress_bar'])) : ?>
                                <div class="mt-4 pt-2 slick-carousel-controls slick-carousel-controls-white">
                                    <div class="row justify-content-center">
                                        <?php if (!empty($settings['progress_bar'])) : ?>
                                            <div class="col-lg-9 col-md-6 pr-4 align-self-center">
                                                <div class="slider-controlprogress">
                                                    <span class="slider__label sr-only"></span>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <?php if (!empty($settings['nav'])) : ?>
                                            <div class="col-lg-3 col-md-6 text-md-right">
                                                <div class="slider-nav"></div>
                                                <div class="slider-dots"></div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php
    }
}

Plugin::instance()->widgets_manager->register(new Panthar_Testimonial_Widget());