<?php

/**
 * Elementor Addons Init
 * @package panthar
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit(); // exit if access directly
}


if ( ! class_exists( 'Panthar_Elementor_Widget_Init' ) ) {

	class Panthar_Elementor_Widget_Init {
	   /**
		* $instance
		* @since 1.0.0
		*/
		private static $instance;

	   /**
		* construct()
		* @since 1.0.0
		*/
		public function __construct() {
			add_action( 'elementor/elements/categories_registered', array( $this, '_widget_categories' ) );
			//elementor widget registered
			add_action( 'elementor/widgets/register', array( $this, '_widget_registered' ) );
			// elementor editor css
			add_action( 'elementor/editor/after_enqueue_scripts', array( $this, 'load_assets_for_elementor' ) );
			//add icon to elementor new icons fileds
			add_filter( 'elementor/icons_manager/native', array( $this, 'add_custom_icon_to_elementor_icons' ) );
		}

		/**
	     * getInstance()
	     * @since 1.0.0
	     */
		public static function getInstance() {
			if ( null == self::$instance ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * _widget_categories()
		 * @since 1.0.0
		 */
		public function _widget_categories( $elements_manager ) {
			$elements_manager->add_category(
				'panthar_widgets',
				[
					'title' => esc_html__( 'Panthar Widgets', 'panthar-core' ),
					'icon'  => 'fas fa-plug',
				]
			);
		}

		/**
		 * _widget_registered()
		 * @since 1.0.0
		 */
		public function _widget_registered() {
			if ( ! class_exists( 'Elementor\Widget_Base' ) ) {
				return;
			}
			$elementor_widgets = array(
				'brand-slider',
				'section-title',
				'boxed-button',
				'list-item',
				'banner',
				'banner-slider',
				'banner-slider-two',
				'banner-slider-three',
				'service',
				'core-value',
				'animate-image',
				'video-hover',
				'team-slider',
				'team-list',
				'team-list-two',
				'blog-grid-list',
				'blog-grid-list-two',
				'icon-box',
				'case-study-slider',
				'case-study-list',
				'testimonial',
				'contact-info',
				'gallery',
				'progressbar',
				'accordion',
				'history',
				'rotate-text',
				'skill-list',
				'gallery-slider',
				'product-grid-list',
			);

			$elementor_widgets = apply_filters( 'panthar_elementor_widget', $elementor_widgets );
			ksort( $elementor_widgets );
			if ( is_array( $elementor_widgets ) && ! empty( $elementor_widgets ) ) {
				foreach ( $elementor_widgets as $widget ) {
					if ( file_exists( PANTHAR_CORE_ELEMENTOR . '/addons/elementor-' . $widget . '-widget.php' ) ) {
						require_once PANTHAR_CORE_ELEMENTOR . '/addons/elementor-' . $widget . '-widget.php';
					}
				}
			}
		}

		public function add_custom_icon_to_elementor_icons( $icons ) {
			$icons['icomoon'] = [
				'name'          => 'icomoon',
				'label'         => esc_html__( 'icomoon', 'panthar-core' ),
				'url'           => PANTHAR_CORE_CSS . '/icomoon.css',
				// icon css file
				'enqueue'       => [ PANTHAR_CORE_CSS . '/icomoon.css' ],
				// icon css file
				'prefix'        => 'icomoon-',
				//prefix ( like fas-fa  )
				'displayPrefix' => '',
				//prefix to display icon
				'labelIcon'     => 'icomoon-Anywhere',
				//tab icon of elementor icons library
				'ver'           => '1.0.0',
				'fetchJson'     => PANTHAR_CORE_JS . '/icomoon.js',
				//json file with icon list example {"icons: ['icon class']}
				'native'        => true,
			];

			return $icons;
		}

		/**
		 * load custom assets for elementor
		 * @since 1.0.0
		 */
		public function load_assets_for_elementor() {
			wp_enqueue_style( 'icomoon', PANTHAR_CORE_CSS . '/icomoon.css' );
			wp_enqueue_style( 'panthar-core-elementor-style', PANTHAR_CORE_ADMIN_ASSETS . '/css/elementor-editor.css' );
		}
	}

	if ( class_exists( 'Panthar_Elementor_Widget_Init' ) ) {
		Panthar_Elementor_Widget_Init::getInstance();
	}
}//end if
