<?php
/**
 * Theme Post Search Widget
 * @package Panthar
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('panthar_post_search_widget', array(
        'title' => esc_html__('Panthar Post Search', 'panthar-core'),
        'classname' => 'widget_search',
        'description' => esc_html__('Display about me widget', 'panthar-core'),
        'fields' => array(
            array(
                'id' => 'title',
                'type' => 'text',
                'title' => esc_html__('Title', 'panthar-core'),
            ),
        )
    ));


    if (!function_exists('panthar_post_search_widget')) {
        function panthar_post_search_widget($args, $instance)
        {

            echo $args['before_widget'];
            $title = $instance['title'] ?? '';

            ?>
                <h4 class="widget-headline"><?php echo esc_html($title); ?></h4>
                <form role="search" action="<?php echo esc_url(home_url('/')) ?>" method="get"
                      class="search-form">
                    <div class="post-inside-wrapper">
                        <div class="form-group">
                            <input type="text" name="s" class="form-control" placeholder="<?php echo esc_attr__('Search here','panthar');?>">
                            <input type="hidden" name="post_type" value="post">
                        </div>
                        <button type="submit" class="submit-btn">
                         <i class="icomoon-search"></i>
                        </button>
                    </div>
                </form>

            <?php
            echo $args['after_widget'];
        }
    }
}
?>