<?php
/**
 * Theme functions & definitations
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Panthar
 */

/**
 * Define Theme Folder Path & URL Constant
 * @package Panthar
 * @since 1.0.0
 */

define('PANTHAR_THEME_ROOT',get_template_directory());
define('PANTHAR_THEME_ROOT_URL',get_template_directory_uri());
define('PANTHAR_INC',PANTHAR_THEME_ROOT .'/inc');
define('PANTHAR_THEME_SETTINGS',PANTHAR_INC.'/theme-settings');
define('PANTHAR_THEME_SETTINGS_IMAGES',PANTHAR_THEME_ROOT_URL.'/inc/theme-settings/images');
define('PANTHAR_TGMA',PANTHAR_INC.'/plugins/tgma');
define('PANTHAR_DYNAMIC_STYLESHEETS',PANTHAR_INC.'/theme-stylesheets');
define('PANTHAR_CSS',PANTHAR_THEME_ROOT_URL.'/assets/css');
define('PANTHAR_JS',PANTHAR_THEME_ROOT_URL.'/assets/js');
define('PANTHAR_ASSETS',PANTHAR_THEME_ROOT_URL.'/assets');
define('PANTHAR_DEV',true);


/**
 * Theme Initial File
 * @package Panthar
 * @since 1.0.0
 */
if (file_exists(PANTHAR_INC .'/theme-init.php')){
	require_once PANTHAR_INC .'/theme-init.php';
}


/**
 * Codester Framework Functions
 * @package Panthar
 * @since 1.0.0
 */
if (file_exists(PANTHAR_INC .'/theme-cs-function.php')){
	require_once PANTHAR_INC .'/theme-cs-function.php';
}


/**
 * Theme Helpers Functions
 * @package Panthar
 * @since 1.0.0
 */
if (file_exists(PANTHAR_INC .'/theme-helper-functions.php')){

	require_once PANTHAR_INC .'/theme-helper-functions.php';
	if (!function_exists('panthar')){
		function panthar(){
			return class_exists('Panthar_Helper_Functions') ? new Panthar_Helper_Functions() : false;
		}
	}
}


/**
 * Nav menu fallback function
 * @since 1.0.0
*/
function panthar_theme_fallback_menu()
{
    get_template_part('template-parts/default', 'menu');
}