<?php
/*
 * Theme Customize Options
 * @package panthar
 * @since 1.0.0
 * */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {
    $prefix = 'panthar';

    CSF::createCustomizeOptions($prefix . '_customize_options');
    /*-------------------------------------
        ** Theme Main panel
    -------------------------------------*/
    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('Panthar Options', 'panthar'),
        'id' => 'panthar_main_panel',
        'priority' => 11,
    ));


    /*-------------------------------------
        ** Theme Main Color
    -------------------------------------*/
    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('01. Main Color', 'panthar'),
        'priority' => 10,
        'parent' => 'panthar_main_panel',
        'fields' => array(
            array(
                'id' => 'main_color',
                'type' => 'color',
                'title' => esc_html__('Theme Main Color One', 'panthar'),
                'default' => '#BA1111',
                'desc' => esc_html__('This is theme primary color one, means it will affect most of elements that have default color of our theme primary color', 'panthar')
            ),
            array(
                'id' => 'main_color_two',
                'type' => 'color',
                'title' => esc_html__('Theme Main Color Two', 'panthar'),
                'default' => '#A37D3D',
                'desc' => esc_html__('This is theme primary color two, means it\'ll affect most of elements that have default color of our theme primary color', 'panthar')
            ),
            array(
                'id' => 'secondary_color',
                'type' => 'color',
                'title' => esc_html__('Theme Secondary Color', 'panthar'),
                'default' => '#19232D',
                'desc' => esc_html__('This is theme secondary color, means it\'ll affect most of elements that have default color of our theme secondary color', 'panthar')
            ),
            array(
                'id' => 'heading_color',
                'type' => 'color',
                'title' => esc_html__('Theme Heading Color', 'panthar'),
                'default' => '#2A2A2A',
                'desc' => esc_html__('This is theme heading color, means it\'ll affect all of heading tag like, h1,h2,h3,h4,h5,h6', 'panthar')
            ),
            array(
                'id' => 'paragraph_color',
                'type' => 'color',
                'title' => esc_html__('Theme Paragraph Color', 'panthar'),
                'default' => '#484848',
                'desc' => esc_html__('This is theme paragraph color, means it\'ll affect all of body/paragraph tag like, p,li,a etc', 'panthar')
            ),
        )
    ));
    /*-------------------------------------
        ** Theme Header Options
    -------------------------------------*/

    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('02. Header One Options', 'panthar'),
        'parent' => 'panthar_main_panel',
        'priority' => 11,
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Nav Bar Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'header_01_nav_bar_bg_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Background Color', 'panthar'),
            ),
            array(
                'id' => 'header_01_nav_bar_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Text Color', 'panthar'),
            ),
            array(
                'id' => 'header_01_nav_bar_hover_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Hover Text Color', 'panthar'),
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Dropdown Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'header_01_dropdown_bg_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Background Color', 'panthar'),
            ),
            array(
                'id' => 'header_01_dropdown_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Text Color', 'panthar'),
            ),
            array(
                'id' => 'header_01_dropdown_border_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Border Color', 'panthar'),
            ),
            array(
                'id' => 'header_01_dropdown_hover_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Hover Text Color', 'panthar'),
            ),
            array(
                'id' => 'header_01_dropdown_hover_bg_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Hover Background Color', 'panthar'),
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Menu Bar Button Right Icon', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'header_01_menu_search_icon_bg_color',
                'type' => 'color',
                'title' => esc_html__('Menu Bar Right Icon Color', 'panthar'),
            ),
            array(
                'id' => 'header_01_menu_right_text_color',
                'type' => 'color',
                'title' => esc_html__('Menu Bar Right Text Color', 'panthar'),
            ),
            array(
                'id' => 'header_01_menu_right_pin_text_color',
                'type' => 'color',
                'title' => esc_html__('Menu Bar Right Pin Text Color', 'panthar'),
            ),
        )
    ));
    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('03. Header Two Options', 'panthar'),
        'parent' => 'panthar_main_panel',
        'priority' => 11,
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Nav Bar Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'header_02_nav_bar_bg_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Background Color', 'panthar'),
            ),
            array(
                'id' => 'header_02_nav_bar_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Text Color', 'panthar'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_02_nav_bar_hover_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Hover Text Color', 'panthar'),
                'default'=> '#ba1111',
            ),

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Menu Bar Button Right Icon', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'header_02_menu_right_search_color',
                'type' => 'color',
                'title' => esc_html__('Menu Bar Right Search Color', 'panthar'),
                'default' => '#ffffff',
            ),
            array(
                'id' => 'header_02_menu_right_menubar_color',
                'type' => 'color',
                'title' => esc_html__('Menu Bar Right Menubar Color', 'panthar'),
            ),

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Dropdown Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'header_02_dropdown_bg_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Background Color', 'panthar'),
            ),
            array(
                'id' => 'header_02_dropdown_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Text Color', 'panthar'),
            ),
            array(
                'id' => 'header_02_dropdown_border_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Border Color', 'panthar'),
            ),
            array(
                'id' => 'header_02_dropdown_hover_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Hover Text Color', 'panthar'),
                'default' => '#ffffff',
            ),
            array(
                'id' => 'header_02_dropdown_hover_bg_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Hover Background Color', 'panthar'),
                'default'=> '#ba1111',
            )
        )
    ));
    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('04. Header Four Options', 'panthar'),
        'parent' => 'panthar_main_panel',
        'priority' => 11,
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Nav Bar Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'header_04_nav_bar_bg_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Background Color', 'panthar'),
            ),
            array(
                'id' => 'header_04_nav_bar_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Text Color', 'panthar'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_04_nav_bar_hover_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Hover Text Color', 'panthar'),
                'default'=> '#7cb82f',
            ),

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Menu Bar Button Right Icon', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'header_04_menu_right_cart_icon_color',
                'type' => 'color',
                'title' => esc_html__('Menu Bar Right Cart Icon Color', 'panthar'),
                'default' => '#ffffff',
            ),
            array(
                'id' => 'header_04_menu_right_cart_color',
                'type' => 'color',
                'title' => esc_html__('Menu Bar Right Cart Color', 'panthar'),
                'default' => '#7cb82f',
            ),
            array(
                'id' => 'header_04_menu_right_btn_color',
                'type' => 'color',
                'title' => esc_html__('Menu Bar Right Btn Color', 'panthar'),
                'default' => '#7cb82f',
            ),

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Dropdown Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'header_04_dropdown_bg_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Background Color', 'panthar'),
            ),
            array(
                'id' => 'header_04_dropdown_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Text Color', 'panthar'),
            ),
            array(
                'id' => 'header_04_dropdown_border_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Border Color', 'panthar'),
            ),
            array(
                'id' => 'header_04_dropdown_hover_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Hover Text Color', 'panthar'),
                'default' => '#ffffff',
            ),
            array(
                'id' => 'header_04_dropdown_hover_bg_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Hover Background Color', 'panthar'),
                'default'=> '#7cb82f',
            )
        )
    ));

    /*-------------------------------------
          ** Theme Sidebar Options
      -------------------------------------*/
    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('06. Sidebar', 'panthar'),
        'priority' => 13,
        'parent' => 'panthar_main_panel',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Sidebar Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'sidebar_widget_title_color',
                'type' => 'color',
                'title' => esc_html__('Sidebar Widget Title Color', 'panthar'),
            ),
            array(
                'id' => 'sidebar_widget_text_color',
                'type' => 'color',
                'title' => esc_html__('Sidebar Widget Text Color', 'panthar'),
                'default' => '#7886a0'
            ),
        )
    ));
    /*-------------------------------------
        ** Theme Footer One Options
    -------------------------------------*/
    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('07. Footer One', 'panthar'),
        'priority' => 14,
        'parent' => 'panthar_main_panel',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'footer_area_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Background Color', 'panthar'),
                'default' => '#0D1422',
            ),
            array(
                'id' => 'footer_area_bottom_border_color',
                'type' => 'color',
                'title' => esc_html__('Footer Bottom Border Color', 'panthar'),
                'default' => 'rgba(255, 255, 255, 0.5)',
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Widget Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'footer_widget_title_color',
                'type' => 'color',
                'title' => esc_html__('Footer Widget Title Color', 'panthar'),
            ),
            array(
                'id' => 'footer_widget_text_color',
                'type' => 'color',
                'title' => esc_html__('Footer Widget Text Color', 'panthar'),
                'default' => '#ffffffb0'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Tag Cloud Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'footer_widget_tag_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Text Color', 'panthar'),
                'default' => '#ffffffb0'
            ),
            array(
                'id' => 'footer_widget_tag_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Background Color', 'panthar'),
                'default' => '#19232d'
            ),
            array(
                'id' => 'footer_widget_tag_border_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Border Color', 'panthar'),
                'default' => '#19232d'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Copyright Area Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'copyright_area_bg_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Area Background Color', 'panthar'),
                'default' => '#0D1422'
            ),
            array(
                'id' => 'copyright_area_text_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Area Text Color', 'panthar'),
                'default' => '#ffffffb0'
            ),
        )
    ));

    /*-------------------------------------
     ** Theme Footer Two Options
    -------------------------------------*/
    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('08. Footer Two', 'panthar'),
        'priority' => 14,
        'parent' => 'panthar_main_panel',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Top Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'footer_two_menu_text_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Text Color', 'panthar'),
                'default' => '#fff'
            ),
            array(
                'id' => 'footer_two_menu_text_hover_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Text Hover Color', 'panthar'),
                'default' => '#DCBB87'
            ),
            array(
                'id' => 'footer_two_menu_contact_icon_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Contact Icon Background Color', 'panthar'),
                'default' => '#19232d'
            ),
            array(
                'id' => 'footer_two_menu_contact_icon_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Contact Icon Color', 'panthar'),
                'default' => '#19232D'
            ),
            array(
                'id' => 'footer_two_menu_contact_title_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Contact Title Color', 'panthar'),
                'default' => '#fff'
            ),
            array(
                'id' => 'footer_two_menu_contact_number_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Contact Number Color', 'panthar'),
                'default' => '#fff'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'footer_area_two_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Background Color', 'panthar'),
                'default' => 'transparent',
            ),
            array(
                'id' => 'footer_area_two_bottom_border_color',
                'type' => 'color',
                'title' => esc_html__('Footer Bottom Border Color', 'panthar'),
                'default' => 'rgba(114, 108, 148, 0.2)',
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Widget Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'footer_two_widget_title_color',
                'type' => 'color',
                'title' => esc_html__('Footer Widget Title Color', 'panthar'),
                'default' => 'rgba(255, 255, 255, 0.9)'
            ),
            array(
                'id' => 'footer_two_widget_text_color',
                'type' => 'color',
                'title' => esc_html__('Footer Widget Text Color', 'panthar'),
                'default' => 'rgba(255,255,255,0.8)'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Tag Cloud Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'footer_widget_two_tag_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Text Color', 'panthar'),
                'default' => '#fff'
            ),
            array(
                'id' => 'footer_widget_two_tag_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Background Color', 'panthar'),
                'default' => 'transparent'
            ),
            array(
                'id' => 'footer_widget_two_tag_border_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Border Color', 'panthar'),
                'default' => '#fff'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Copyright Area Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'copyright_two_area_bg_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Area Background Color', 'panthar'),
                'default' => 'transparent'
            ),
            array(
                'id' => 'copyright_two_area_text_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Area Text Color', 'panthar'),
                'default' => 'rgba(255,255,255,0.8)'
            ),
        )
    ));

    /*-------------------------------------
    ** Theme Footer Three Options
    -------------------------------------*/
    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('09. Footer Three', 'panthar'),
        'priority' => 14,
        'parent' => 'panthar_main_panel',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Top Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'footer_three_menu_text_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Text Color', 'panthar'),
                'default' => '#fff'
            ),
            array(
                'id' => 'footer_three_menu_text_hover_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Text Hover Color', 'panthar'),
                'default' => '#DCBB87'
            ),
            array(
                'id' => 'footer_three_menu_contact_icon_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Contact Icon Background Color', 'panthar'),
                'default' => '#19232d'
            ),
            array(
                'id' => 'footer_three_menu_contact_icon_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Contact Icon Color', 'panthar'),
                'default' => '#19232D'
            ),
            array(
                'id' => 'footer_three_menu_contact_title_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Contact Title Color', 'panthar'),
                'default' => '#fff'
            ),
            array(
                'id' => 'footer_three_menu_contact_number_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Contact Number Color', 'panthar'),
                'default' => '#fff'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'footer_area_three_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Background Color', 'panthar'),
                'default' => 'transparent',
            ),
            array(
                'id' => 'footer_area_three_bottom_border_color',
                'type' => 'color',
                'title' => esc_html__('Footer Bottom Border Color', 'panthar'),
                'default' => 'rgba(114, 108, 148, 0.2)',
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Widget Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'footer_three_widget_title_color',
                'type' => 'color',
                'title' => esc_html__('Footer Widget Title Color', 'panthar'),
                'default' => 'rgba(255, 255, 255, 0.9)'
            ),
            array(
                'id' => 'footer_three_widget_text_color',
                'type' => 'color',
                'title' => esc_html__('Footer Widget Text Color', 'panthar'),
                'default' => 'rgba(255,255,255,0.8)'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Tag Cloud Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'footer_widget_three_tag_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Text Color', 'panthar'),
                'default' => '#fff'
            ),
            array(
                'id' => 'footer_widget_three_tag_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Background Color', 'panthar'),
                'default' => 'transparent'
            ),
            array(
                'id' => 'footer_widget_three_tag_border_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Border Color', 'panthar'),
                'default' => '#fff'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Copyright Area Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'copyright_three_area_bg_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Area Background Color', 'panthar'),
                'default' => 'transparent'
            ),
            array(
                'id' => 'copyright_three_area_text_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Area Text Color', 'panthar'),
                'default' => 'rgba(255,255,255,0.8)'
            ),
        )
    ));

    /*-------------------------------------
    ** Theme Footer Four Options
    -------------------------------------*/
    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('10. Footer Four', 'panthar'),
        'priority' => 14,
        'parent' => 'panthar_main_panel',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Top Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'footer_four_menu_text_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Text Color', 'panthar'),
                'default' => '#fff'
            ),
            array(
                'id' => 'footer_four_menu_text_hover_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Text Hover Color', 'panthar'),
                'default' => '#DCBB87'
            ),
            array(
                'id' => 'footer_four_menu_contact_icon_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Contact Icon Background Color', 'panthar'),
                'default' => '#19232d'
            ),
            array(
                'id' => 'footer_four_menu_contact_icon_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Contact Icon Color', 'panthar'),
                'default' => '#19232D'
            ),
            array(
                'id' => 'footer_four_menu_contact_title_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Contact Title Color', 'panthar'),
                'default' => '#fff'
            ),
            array(
                'id' => 'footer_four_menu_contact_number_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Contact Number Color', 'panthar'),
                'default' => '#fff'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'footer_area_four_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Background Color', 'panthar'),
                'default' => 'transparent',
            ),
            array(
                'id' => 'footer_area_four_bottom_border_color',
                'type' => 'color',
                'title' => esc_html__('Footer Bottom Border Color', 'panthar'),
                'default' => 'rgba(114, 108, 148, 0.2)',
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Widget Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'footer_four_widget_title_color',
                'type' => 'color',
                'title' => esc_html__('Footer Widget Title Color', 'panthar'),
                'default' => 'rgba(255, 255, 255, 0.9)'
            ),
            array(
                'id' => 'footer_four_widget_text_color',
                'type' => 'color',
                'title' => esc_html__('Footer Widget Text Color', 'panthar'),
                'default' => 'rgba(255,255,255,0.8)'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Tag Cloud Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'footer_widget_four_tag_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Text Color', 'panthar'),
                'default' => '#fff'
            ),
            array(
                'id' => 'footer_widget_four_tag_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Background Color', 'panthar'),
                'default' => 'transparent'
            ),
            array(
                'id' => 'footer_widget_four_tag_border_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Border Color', 'panthar'),
                'default' => '#fff'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Copyright Area Options', 'panthar') . '</h3>'
            ),
            array(
                'id' => 'copyright_four_area_bg_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Area Background Color', 'panthar'),
                'default' => 'transparent'
            ),
            array(
                'id' => 'copyright_four_area_text_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Area Text Color', 'panthar'),
                'default' => 'rgba(255,255,255,0.8)'
            ),
        )
    ));


}//endif