<?php
/**
 * Footer Style 01
 * @package panthar
 * @since 1.0.0
 */

$copyright_text = !empty(cs_get_option('copyright_text')) ? cs_get_option('copyright_text') : esc_html__('Copyright 2022 Panthar. Designed By ', 'panthar') . '<a href="' . esc_url('https://themeforest.net/user/themeim/portfolio') . '">' . esc_html__('ThemeIM', 'panthar') . '</a>';
$copyright_text = str_replace('{copy}', '&copy;', $copyright_text);
$copyright_text = str_replace('{year}', date('Y'), $copyright_text);
$socialIcon = cs_get_option('footer_social_repeater');
$footer_top_widget = cs_get_option('footer_two_top_repeater');

?>
<!-- footer area start -->
<div class="footer-style-1">
    <footer class="footer-wrap bg-image">
        <?php 
            $footer_logo = cs_get_option('footer_logo');
            $footer_subscribe = cs_get_option('footer_subscribe');
            if(!empty($footer_logo || $footer_subscribe)) : ?>
                <div class="container padding-top-120">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="footer-top-logo mb-4 mb-lg-0 mt-3">
                                <?php
                                    if (has_custom_logo() && empty($header_two_logo['id'])) {
                                        the_custom_logo();
                                    } elseif (!empty($footer_logo['id'])) {
                                        printf('<a class="site-logo" href="%1$s"><img src="%2$s" alt="%3$s"/></a>', esc_url(get_home_url()), $footer_logo['url'], $footer_logo['alt']);
                                    } else {
                                        printf('<a class="site-title" href="%1$s">%2$s</a>', esc_url(get_home_url()), esc_html(get_bloginfo('title')));
                                    }
                                    ?>
                            </div>
                        </div>
                        <div class="col-lg-8">
                            <?php echo do_shortcode($footer_subscribe); ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <div class="container">
            <div class="footer-top padding-top-70">
                <div class="footer-widget-wrap">
                    <div class="row">
                        <?php dynamic_sidebar('footer-widget'); ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="copyright-wrap">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="copyright-wrap-inner">
                            <div class="copyright-text">
                                <?php
                                echo wp_kses($copyright_text, panthar()->kses_allowed_html(array('a')));
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
</div>
<!-- footer area end -->