<?php
/**
 * Footer Style 03
 * @package panthar
 * @since 1.0.0
 */

$copyright_text = !empty(cs_get_option('copyright_text')) ? cs_get_option('copyright_text') : esc_html__('Copyright 2022. Designed By ', 'panthar') . '<a href="' . esc_url('https://themeforest.net/user/themeim/portfolio') . '">' . esc_html__('ThemeIM', 'panthar') . '</a>';
$copyright_text = str_replace('{copy}', '&copy;', $copyright_text);
$copyright_text = str_replace('{year}', date('Y'), $copyright_text);
$socialIcon = cs_get_option('footer_social_repeater');
$footer_top_widget = cs_get_option('footer_two_top_repeater');
$footer_three_social_shortcode = cs_get_option('footer_three_social_shortcode');
$footer_three_bottom_img = cs_get_option('footer_three_bottom_img');

?>
<!-- footer area start -->
<div class="footer-style-1 footer-style-3">
    <footer class="footer-wrap bg-image">
        <div class="container">
            <div class="footer-top padding-top-70">
                <div class="footer-widget-wrap">
                    <div class="row">
                        <?php dynamic_sidebar('footer-widget-three'); ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="copyright-wrap">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4 align-self-center">
                        <div class="copyright-wrap-inner">
                            <div class="copyright-text">
                                <?php
                                echo wp_kses($copyright_text, panthar()->kses_allowed_html(array('a')));
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 align-self-center">
                        <div class="footer-bottom-social">
                            <?php echo do_shortcode($footer_three_social_shortcode); ?>
                        </div>
                    </div>
                    <div class="col-lg-4 align-self-center">
                        <div class="footer-bottom-img">
                            <?php
                                $footer_three_bottom_imgs = explode( ',', $footer_three_bottom_img );
                            ?>
                            <?php
                                if ( ! empty( $footer_three_bottom_imgs ) ) {
                                    foreach ( $footer_three_bottom_imgs as $footer_three_bottom_imgs_id ) { ?>
                                        <?php echo wp_get_attachment_image( $footer_three_bottom_imgs_id, 'full' ); ?>
                                    <?php } 
                                };
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
</div>
<!-- footer area end -->