<?php
/**
 * Header Style 01
 * @package panthar
 * @since 1.0.0
 */

?>
<div class="header-style-01">
    <?php
    $has_top_bar = 'no-topbar';
    $has_nav_btn = !empty(cs_get_option('header_two_top_navbar_button')) ? 'has-nav-button' : 'no-nav-button';
    $shortcodes_right_content = cs_get_option('header_two_top_right_bar_shortcode');
    $shortcodes_left_content = cs_get_option('header_two_top_left_bar_shortcode');
    if (!empty($shortcodes_right_content) || !empty($shortcodes_left_content)) : $has_top_bar = 'has-topbar';
    $class = is_rtl() ? '':'text-lg-right';
    ?>
    <div class="navbar-top">
        <div class="container custom-container">
            <div class="row">
                <div class="col-lg-5">
                    <div class="left-content">
                        <i class="icomoon-share"></i>
                        <?php
                        echo do_shortcode($shortcodes_left_content); ?>
                    </div>
                </div>
                <div class="col-lg-7">
                    <div class="right-content <?php echo esc_attr($class);?>">
                        <?php echo do_shortcode($shortcodes_right_content); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <nav class="navbar navbar-area navbar-expand-lg navigation-style-01 navbar-default">
        <div class="container custom-container">
            <div class="responsive-mobile-menu">
                <div class="logo-wrapper">
                    <?php
                    $header_two_logo = cs_get_option('header_two_logo');
                    if (has_custom_logo() && empty($header_two_logo['id'])) {
                        the_custom_logo();
                    } elseif (!empty($header_two_logo['id'])) {
                        printf('<a class="site-logo" href="%1$s"><img src="%2$s" alt="%3$s"/></a>', esc_url(get_home_url()), $header_two_logo['url'], $header_two_logo['alt']);
                    } else {
                        printf('<a class="site-title" href="%1$s">%2$s</a>', esc_url(get_home_url()), esc_html(get_bloginfo('title')));
                    }
                    ?>
                </div>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#panthar_main_menu"
                        aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
            </div>
            <?php
            wp_nav_menu(array(
                'theme_location' => 'main-menu',
                'menu_class' => 'navbar-nav w-100 text-lg-right',
                'container' => 'div',
                'container_class' => 'collapse navbar-collapse',
                'container_id' => 'panthar_main_menu'
            ));
            ?>
            <div class="nav-right-content">
                <div class="align-self-center header-search" id="search">
                    <i class="icomoon-search"></i>
                </div>
                <?php if (!empty(cs_get_option('header_two_navbar_button_info'))) : ?>
                    <div class="nav-right-content-info">
                        <h3 class="title">
                            <?php
                            $title = str_replace( [ '{c}', '{/c}' ], [ '<span>', '</span>' ], cs_get_option('header_two_navbar_title') );
                            print wp_kses( $title, panthar()->kses_allowed_html( 'all' ) );
                            ?>
                        </h3>
                        <span><a href="tel:<?php echo esc_attr(cs_get_option('header_two_navbar_number')); ?>"><?php echo esc_html(cs_get_option('header_two_navbar_number')); ?></a></span>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </nav>
</div>