<?php
/**
 * Header Style 02
 * @package panthar
 * @since 1.0.0
 */

?>
<div class="header-style-02">
    <?php
    $has_nav_btn = !empty(cs_get_option('header_two_top_navbar_button')) ? 'has-nav-button' : 'no-nav-button';
    $header_three_image_gallery = cs_get_option('header_three_image_gallery');
    $header_three_right_content = cs_get_option('header_three_right_content');
    $header_three_info_detail_title = cs_get_option('header_three_info_detail_title');
    $header_three_right_info = cs_get_option('header_three_right_info');
    $header_three_right_social = cs_get_option('header_three_right_social');


    ?>
    <div class="body-overlay"></div>
    <div class="navbar-right-side" id="sidebar-menu">
        <div class="sidebar-inner"> 
            <div class="close-btn sidebar-menu-close"><i class="fa fa-times"></i></div>
            <div class="logo-wrapper p-0">
                <?php
                $header_three_logo = cs_get_option('header_three_logo');
                if (has_custom_logo() && empty($header_three_logo['id'])) {
                    the_custom_logo();
                } elseif (!empty($header_three_logo['id'])) {
                    printf('<a class="site-logo" href="%1$s"><img src="%2$s" alt="%3$s"/></a>', esc_url(get_home_url()), $header_three_logo['url'], $header_three_logo['alt']);
                } else {
                    printf('<a class="site-title" href="%1$s">%2$s</a>', esc_url(get_home_url()), esc_html(get_bloginfo('title')));
                }
                ?>
            </div>
            <ul class="media-gallery">
                <?php foreach ($header_three_image_gallery as $gallery_imgs) { 

                    $gallery_img_url = $gallery_imgs['header_three_gallery']; ?>

                    <li><img src="<?php echo esc_url($gallery_img_url['url']); ?>" alt=""></li>
                    
                <?php } ?>
            </ul>

            <p class="content"><?php echo esc_html($header_three_right_content); ?></p>
            <h4><?php echo esc_html($header_three_info_detail_title); ?></h4>

            <ul class="right-info">
                <?php foreach ($header_three_right_info as $header_right_info) { 
                    $header_three_info_day = $header_right_info['header_three_info_day']; 
                    $header_three_info_time = $header_right_info['header_three_info_time']; ?>

                    <li>
                        <?php echo esc_html($header_three_info_day); ?> <br>    
                        <?php echo esc_html($header_three_info_time); ?>    
                    </li>
                    
                <?php } ?>
            </ul>

            <ul class="social-info">
                <?php foreach ($header_three_right_social as $header_right_social) { 
                    $header_three_social = $header_right_social['header_three_social'];
                    $header_three_social_url = $header_right_social['header_three_social_url']; 

                    if(!empty($header_three_social)) :?>
                        <li><a href="<?php echo esc_url($header_three_social_url); ?>"><i class="<?php echo esc_attr($header_three_social); ?>"></i></a></li>
                    <?php endif; ?>
                    
                <?php } ?>
            </ul>
        </div>
    </div>
    <!-- start navbar -->
    <nav class="navbar navbar-area navbar-expand-lg navigation-style-02 navbar-default">
        <div class="container custom-container">
            <div class="responsive-mobile-menu">
                <div class="logo-wrapper default-logo">
                    <?php
                    $header_three_logo = cs_get_option('header_three_logo');
                    if (has_custom_logo() && empty($header_three_logo['id'])) {
                        the_custom_logo();
                    } elseif (!empty($header_three_logo['id'])) {
                        printf('<a class="site-logo" href="%1$s"><img src="%2$s" alt="%3$s"/></a>', esc_url(get_home_url()), $header_three_logo['url'], $header_three_logo['alt']);
                    } else {
                        printf('<a class="site-title" href="%1$s">%2$s</a>', esc_url(get_home_url()), esc_html(get_bloginfo('title')));
                    }
                    ?>
                </div>
                <div class="logo-wrapper logo-sticky">
                    <?php
                    $header_three_logo_sticky = cs_get_option('header_three_logo_sticky');
                    if (has_custom_logo() && empty($header_three_logo_sticky['id'])) {
                        the_custom_logo();
                    } elseif (!empty($header_three_logo_sticky['id'])) {
                        printf('<a class="site-logo" href="%1$s"><img src="%2$s" alt="%3$s"/></a>', esc_url(get_home_url()), $header_three_logo_sticky['url'], $header_three_logo_sticky['alt']);
                    } else {
                        printf('<a class="site-title" href="%1$s">%2$s</a>', esc_url(get_home_url()), esc_html(get_bloginfo('title')));
                    }
                    ?>
                </div>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#panthar_main_menu"
                        aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
            </div>
            <?php
            wp_nav_menu(array(
                'theme_location' => 'main-menu',
                'menu_class' => 'navbar-nav w-100',
                'container' => 'div',
                'container_class' => 'collapse navbar-collapse',
                'container_id' => 'panthar_main_menu'
            ));
            ?>
            <div class="nav-right-content">
                <div class="align-self-center header-search" id="search">
                    <i class="icomoon-search"></i>
                </div>
                <?php if (!empty(cs_get_option('header_two_navbar_button_info'))) : ?>
                    <div class="nav-right-content-info">
                        <a class="navigation-button" id="navigation-button" href="#">
                            <svg xmlns="http://www.w3.org/2000/svg" width="30" height="31" viewBox="0 0 30 31">
                              <g data-name="Group 7139" transform="translate(-1703 -63)">
                                <rect data-name="Rectangle 774" width="10" height="10" rx="3" transform="translate(1713 74)" fill="#fff"/>
                                <g data-name="Group 4263">
                                  <rect data-name="Rectangle 771" width="10" height="10" rx="3" transform="translate(1723 63)" fill="#ba1111"/>
                                  <rect data-name="Rectangle 773" width="10" height="10" rx="3" transform="translate(1723 84)" fill="#ba1111"/>
                                  <rect data-name="Rectangle 772" width="10" height="10" rx="3" transform="translate(1703 63)" fill="#ba1111"/>
                                  <rect data-name="Rectangle 775" width="10" height="10" rx="3" transform="translate(1703 84)" fill="#ba1111"/>
                                </g>
                              </g>
                            </svg>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </nav>
</div>